IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS 
				WHERE OBJECT_ID = OBJECT_ID (N'EST_PROD_PRECO_TBL_HIST_CPL') 
				AND NAME ='ZONA_FRANCA')
begin
    ALTER TABLE EST_PROD_PRECO_TBL_HIST_CPL ADD ZONA_FRANCA tinyint DEFAULT 0 NOT NULL 
end
go

if exists (SELECT name, SCHEMA_NAME(schema_id) AS schema_name, type_desc 
		  FROM sys.objects WHERE  parent_object_id = (OBJECT_ID('dbo.EST_PROD_PRECO_TBL_HIST_CPL')) 
			 AND type IN ('PK')) and EXISTS (SELECT 1 FROM SYS.COLUMNS 
								    WHERE OBJECT_ID = OBJECT_ID (N'EST_PROD_PRECO_TBL_HIST_CPL') 
				AND NAME ='ZONA_FRANCA')
begin
    ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] DROP   [PK_EST_PROD_PRECO_TBL_HIST_CPL] WITH ( ONLINE = OFF )


    ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] ADD  CONSTRAINT [PK_EST_PROD_PRECO_TBL_HIST_CPL] PRIMARY KEY CLUSTERED 
    (
	    [CD_EMP] ASC,
	    [CD_CTR] ASC,
	    [CD_PROD] ASC,
	    [PERC_ICMS] ASC,
	    [ZONA_FRANCA] ASC
    )WITH (PAD_INDEX = OFF, 
		  STATISTICS_NORECOMPUTE = OFF,  
		  IGNORE_DUP_KEY = OFF,  
		  ALLOW_ROW_LOCKS = ON, 
		  ALLOW_PAGE_LOCKS = ON, 
		  FILLFACTOR = 90) ON [PRIMARY]

end


